max_switches = 6
switches = new Array();
for (var i=0;i<max_switches;i++)
{
	switches[i] = Object();
	switches[i].status = -1
}

function CheckForSwitches(i)
{
	tilex = Math.floor(entities[i].x/16);
	tiley = Math.floor(entities[i].y/16);
	if (tilex >= 0 && tilex < GetLayerWidth(0) && tiley >= 0 && tiley < GetLayerHeight(0))
	{
		tile = GetTile(tilex, tiley, 2);
		if (tile >= 7 && tile <= 14)
		{
			if (tile%2 == 1)
			{
				//this is a depressed switch, so we're going to press it now:
				switch_number = Math.floor((tile -7)/2)+1;//#1-4, Red, Green, Blue, Yellow
				switches[switch_number].status *= -1//pressed now:
				PlaySound(4)
	
				UpdateSwitches();
			}
		}
	}
}

function UpdateSwitches()
{
	for (var i=0;i<GetLayerWidth(0);i++)
	{
		for (var j=0;j<GetLayerHeight(0);j++)
		{
			tile = GetTile(i, j, 0)
			if (tile >= 7 && tile <= 14)
			{
				switch_number = Math.floor((tile-7)/2)+1;
				default_state = ((tile-7)%2)*2-1
				if (default_state == -1)
				{
					if (switches[switch_number].status == -1)//default off, switch off, default on, switch on
					{
						SetTile(i,j,2, 7+2*(switch_number-1))
					}
					else
					{
						SetTile(i,j,2, 7+2*(switch_number-1)+1)
					}
				}
				else
				{
					if (switches[switch_number].status == -1)//default off, switch off, default on, switch on
					{
						SetTile(i,j,2, 7+2*(switch_number-1)+1)
					}
					else
					{
						SetTile(i,j,2, 7+2*(switch_number-1))
					}
				}
			}
		}
	}
	UpdateDoors();
}

function UpdateDoors()
{
	for (var i=0;i<GetLayerWidth(0);i++)
	{
		for (var j=0;j<GetLayerHeight(0);j++)
		{
			tile = GetTile(i,j,2);
			if ((tile >=143 && tile <= 152 ) || (tile >=156 && tile <= 165 ))
			{

				door_num = GetTile(i,j,0)-116
				if (door_num > 0 && door_num < 5)
				{
					for (var k=0;k<maps[g_current_level].doors.length;k++)
					{
						this_door = maps[g_current_level].doors[k]
						if (this_door[0] == door_num)
						{
							if (this_door[3] == 0)
							{
								if (tile <156)
								{
									SetTile(i,j,2, 151)
								}
								else
								{
									SetTile(i,j,2, 164)
								}
							
							}
							else
							{
								is_bottom = 0
								if (tile >= 156)
								{
									is_bottom = 1;
								}
								door_colour = Math.abs(this_door[3])
								if (switches[Math.abs(this_door[3])].status == Math.sign(this_door[3]))
								{
									//should be open
									if (is_bottom)
									{
										SetTile(i,j,2, 156+2*(door_colour-1))
									}
									else
									{
										SetTile(i,j,2, 143+2*(door_colour-1))
									}
								}
								else
								{

									//should be closed
									if (is_bottom)
									{
				
										SetTile(i,j,2, 157+2*(door_colour-1))
									}
									else
									{
										SetTile(i,j,2, 144+2*(door_colour-1))
									}
								}
							}
							break
						}
					}
				}
			}
		}
	}
	UpdateGates()
}

function UpdateGates()
{
	for (var i=0;i<GetLayerWidth(0);i++)
	{
		for (var j=0;j<GetLayerHeight(0);j++)
		{
			tile = GetTile(i,j,2);
			if ((tile >=169 && tile <= 178) || (tile >=182 && tile <= 191 ))
			{
				tile_o = GetTile(i,j,3)
				if (tile_o >= 208)
				{
					gate_default = -1;//closed
				}
				else
				{
					gate_default = 1;//open
				}

				if (tile >=169 && tile <= 178)
				{
					gate_num = Math.floor((tile-169)/2)+1
					
				}
				if (tile >=182 && tile <= 191)
				{
					gate_num = Math.floor((tile-182)/2)+1
				}

				if (gate_num > 0 && gate_num < 5)
				{
					if (switches[gate_num].status*gate_default == 1)
					{
						//gate is open
						if (tile >= 169 && tile <=178)
						{
							//top
							SetTile(i,j, 2, 169+(gate_num-1)*2)
						}
						else
						{
							SetTile(i,j, 2, 182+(gate_num-1)*2)
							//bottom
						}
						SetTile(i,j, 0, 0)
					}
					else
					{
						//gate is closed
						if (tile >= 169 && tile <=178)
						{
							//top
							SetTile(i,j, 2, 170+(gate_num-1)*2)
						}
						else
						{
							//bottom
							SetTile(i,j, 2, 183+(gate_num-1)*2)
						}
						SetTile(i,j, 0, 3)
					
					}
				}
			}

		}
	
	}
}



function LightBomb(i)
{
	entities[i].timer = 1;
	entities[i].direction = 'explodeeast'
	entities[i].frame = 0;
	
}

bomb_frames = 4*60;

function UpdateBomb(i)
{
	m = 500;
	if (entities[i].active == true && entities[i].type == 2)
	{
		if (entities[i].timer > 0)
		{
			entities[i].timer+=1;
			
			if (entities[i].timer < bomb_frames)
			{
				frame = 1-Math.round(0.5*Math.sin(3.1415/((30+bomb_frames-entities[i].timer)/m))+0.5)
				entities[i].frame = frame;
			}
			else
			{
				if (g_frames%4 ==0)
				{
					entities[i].frame+=1;
					if (entities[i].frame == 2)
					{
						DoBombExplode(i)
					}
					if (entities[i].frame == 6)
					{
						entities[i].timer = 0
						entities[i].active = false;
						if (entities[0].grab == i)
						{
							entities[0].grab = -1;
							entities[i].grabbed = -1;
						}
					}
				}
			}
		}
	
	}
}
 
 
function DoBombExplode(i)
{
	tilex = Math.floor(entities[i].x/16)
	tiley = Math.floor(entities[i].y/16)
	PlaySound(1);
	
	sx = tilex-2
	sy = tiley-2
	for (var sx=tilex-2;sx<tilex+3;sx++)
	{
		for (var sy=tiley-2;sy<tiley+3;sy++)
		{
			if (sx < 0 || sy < 0 || sx > GetLayerWidth(0)-1 || sy > GetLayerHeight(0)-1)
			{
			
			}
			else
			{
				tile = GetTile(sx,sy, 0)
				if (tile == 38)
				{
					SetTile(sx, sy, 0, 0)
					SetTile(sx, sy, 2, 0)
				}
			}
		}
	}

}


